#!/bin/bash
#This script is used to run the MRIC model with different beta values for the attack
start_time=$(date +%s)



batch_size=8
bs=(0.0 0.16 0.32 0.64 1.28 2.56)

echo "Running task with b: $b"

echo "GPU & CUDA info"
nvcc --version
nvidia-smi
echo "=============================================================="
source conda.sh
conda activate 
export LD_LIBRARY_PATH=$CONDA_PREFIX/lib:$LD_LIBRARY_PATH
python3 -c "import tensorflow as tf; print(tf.config.list_physical_devices('GPU'))"
for b in ${bs[@]}
do
    python MRIC.py --beta=$b --model_path='MRIC' --batch_size=$batch_size
done
end_time=$(date +%s)
execution_time=$((end_time - start_time))

echo "Execution time: $execution_time seconds"
echo "finished"